### 概述

客户端通过使用Acp库文件，使用ST语言功能块对已安装有ACP功能的工控机进行变量的读写。

连接拓扑图：
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680221ead2db2.png)

下表概述了各个产品组件

| **产品组件**                     | **描述说明**   |
| ---------------------------- | ---------- |
| DeviceManager\_0.0.1.9       | 插件管理器      |
| AcpServer.projectarchive     | PLC服务端工程存档 |
| AcpClient.projectarchive     | PLC客户端工程存档 |
| SF1000\_ACPBaseLibs\_1.0.1.0 | PLC库文件     |
| SF1000\_AcpSymbol\_1.0.1.1   | PLC库文件     |

---
### 安装卸载

**安装要求**

* 中科时代出厂的工智机的自带系统；

* 个人电脑可以访问互联网；


**安装过程**

 **1、服务端工智机安装acpplcaccess.deb组件**

1.打开Device Manager软件
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/6802220958af9.png)

2.初次使用，需要安装ACP通讯服务。点击左下角“安装ACP服务”。
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/68022212915c5.png)

3.输入工智机固定IP地址、端口、用户名和密码后，点击“在线安装”。

| IP地址 | 192.168.1.200 |
| ---- | ------------- |
| 端口   | 2224          |
| 用户名  | sinsegye      |
| 密码   | 1             |

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/6802221cebae7.png)


等待安装完成。
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/6802222bb198c.png)


4.安装完成后，点击“扫描”，即可扫描出固定网口192.168.1.200连接的工智机。
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/68022236775de.png)


点击进入工智机后，左下角显示“已连接”状态。
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/6802223fea45d.png)


5.点击“安装RTE插件服务”
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/68022247c8764.png)

6.输入用户名：sinsegye，密码：1，点击“在线安装”
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/68022250c3b49.png)


7.安装完成后，点击“软件”，在下拉菜单下选择“组件管理”
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/6802225c50249.png)

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/68022263f03c9.png)

8.点击浏览，可以在线浏览可以安装的组件。
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/6802226eecdc4.png)

9.在组件中找到“SF1000-acpplcaccess”--点击“安装”
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/68022278c9955.png)

10.等待deb包传送到工智机中，传送完成后点击“确定”进行安装。
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680222822abd0.png)


11.安装完成后，点击“确认”重启生效。
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/6802228d6c05f.png)


12.安装完成后，可以在“本地”页面浏览到SF1000-acpplcaccess已安装成功。
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680222967b98b.png)

**2、客户端工智机SF1000-siacpbaselibs.deb组件**

1.打开Device Manager软件

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680222a2d20f7.png)

2.初次使用，需要安装ACP通讯服务。点击左下角“安装ACP服务”。
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680222abebfa1.png)

3.输入工智机固定IP地址、端口、用户名和密码后，点击“在线安装”。

| IP地址 | 192.168.110.195 |
| ---- | --------------- |
| 端口   | 2224            |
| 用户名  | sinsegye        |
| 密码   | 1               |

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680222bb44af7.png)


等待安装完成。

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680222c23a9d9.png)


4.安装完成后，点击“扫描”，即可扫描出固定网口192.168.110.195连接的工智机。

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680222ca45651.png)


点击进入工智机后，左下角显示“已连接”状态。
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680222d26a3b9.png)

5.点击“安装RTE插件服务”
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680222e2185ce.png)

6.输入用户名：sinsegye，密码：1，点击“在线安装”

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680222eb69da2.png)

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680222f2e0e1c.png)


7.安装完成后，点击“软件”，在下拉菜单下选择“组件管理”

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680222fb827d7.png)


8.点击浏览，可以在线浏览可以安装的组件。

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/68022321afc1c.png)


9.在组件中找到“SF1000-siacpbaselibs”--点击“安装”

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/6802232db2638.png)


10.等待deb包传送到工智机中，传送完成后点击“确定”进行安装。
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/68022337b143e.png)


11.安装完成后，点击“确认”重启生效。
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680223410e9c0.png)


12.安装完成后，可以在“本地”页面浏览到SF1000-siacpbaselibs已安装成功。

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680223480bb08.png)


**3、客户端工智机安装SF1000\_ACPBaseLibs和SF1000\_AcpSymbol库文件**

打开MataFacture IDE软件，选择“工具”--“库存储”
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/68022352b5490.png)


点击“安装”
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/6802235addcee.png)

选择从中科时代官网下载的SF1000\_ACPBaseLibs和SF1000\_AcpSymbol库文件，点击“打开”
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/68022363192ae.png)


等待库文件安装完成即可。
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/6802236ea3c18.png)


**更新安装**

1.服务端更新acpplcaccess组件

在插件管理器Device Mananger--组件管理--本地组件中，点击SF1000-acpplcaccess，选择可更新的版本后，点击“更新”。
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/6802237f3cbf5.png)

2.客户端更新SF1000-siacpbaselibs组件

在插件管理器Device Mananger--组件管理--本地组件中，点击SF1000-siacpbaselibs，选择可更新的版本后，点击“更新”。

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680223889feff.png)

3.更新PLC库文件

下载最新版的MetaFacture IDE自带最新版的SF1000\_ACPBaseLibs和SF1000\_AcpSymbol库文件，如需手动更新，下载最新库文件后，参考《**安装过程**》进行覆盖安装即可。



**卸载过程**

**卸载工智机deb组件**

在插件管理器Device Mananger--组件管理--本地组件中，点击SF1000-acpplcaccess，选择“卸载”
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680223a1807be.png)

点击“确定”
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680223a9ced71.png)

卸载成功后，点击“确定”重启生效。

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680223b1b97f5.png)


卸载成功后，“本地”页面组件消失。

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680223bc9acf9.png)




---
### 技术说明

**快速启动**

**（一）本例软、硬件配置**

**硬件：**

1. 服务端工智机SX21

2. 客户端工智机SX5132

3. 工业交换机

4. 个人电脑

**软件：**

1. DeviceManager\_0.0.1.9

2. AcpServer.projectarchive

3. AcpClient.projectarchive

4. MetaFacture IDE



 **（二）本例实验操作步骤**

**1.1 实验原理图**

将服务端工智机与客户端工智机通过交换机相连接

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680223e8be839.png)


**1.3 实验步骤**

a.解压服务端PLC工程存档AcpServer.projectarchive，登录下载至服务端工智机。
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680224099fc94.png)

b.解压客户端PLC工程存档AcpClient.projectarchive。

c.修改客户端PLC中的netId为服务端IP，登录下载至服务端工智机
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/68022415265b9.png)

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/6802241fdcc7d.png)

d.将xRead置TRUE，ReadData显示读取值4294967295

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/6802242b45e0f.png)

e.修改变量WriteData的值，将xWrite变量置TRUE，写入变量值。
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/68022433c2e61.png)


查看服务端PLC的udiVar11，成功写入1122334455.
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/6802243e6aba9.png)


f.再次将xRead置False后置True，ReadData读取为新修改的数值。
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/6802244b23f80.png)


---
### 二、示例

1.将官方网站下载的示例AcpServer工程下载到服务端工智机中。

示例AcpServer工程包含一个结构体：
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680224682a889.png)

各类型变量，并赋予初始值：
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/6802247435eda.png)

已编译的符号配置
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/6802247f932c4.png)


2.在个人电脑中新建示例工程，命名AcpClient
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/68022487f292e.png)

3.选择适合自己的编程语言，点击“确定”
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680224987794f.png)

4.点击“库管理器”—“添加库”，添加SF1000\_ACPBaseLibs和SF1000\_AcpSymbol两个库文件
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680224a194b08.png)

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680224ad44d65.png)

5.在PLC程序声明中，实例化功能块MetaCore\_AcpSymbol.FB\_AcpReadSymbol和MetaCore\_AcpSymbol.FB\_AcpWriteSymbol功能块
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680224b8ebfbb.png)

7.在PLC程序中，鼠标右键--选择“输入助手”
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680224c1a64b8.png)

8.选择“实例调用”--选择“Read”功能块，点击“确定”
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680224cc5c486.png)

9.PLC程序将自动添加Read功能块。
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680224d548e99.png)

10.声明变量，本例读取客户端的变量为Application.PLC\_PRG.udiVar11，类型为UDINT。将读取的数据保存在ReadData变量中。

| 参数名称     | 参数类型                   | 描述说明                                        |
| -------- | ---------------------- | ------------------------------------------- |
| targetId |  ARRAY\[0..5] OF USINT | 连接服务端的IP地址，数组类型，最后两位固定为1                    |
| bExecute | BOOL                   | 上升沿启动功能块，进行ACP变量读取，                         |
| symbol   | String                 | 读取服务端的变量地址，如‘Application.PLC\_PRG.udiVar11’ |
| pDst     | Pointer to BYTE        | 读取服务端的变量数据，数值以BYTE的形式存储在指针指向的地址中            |
| cbDst    | UDINT                  | 读取服务端的变量数据长度，使用SIZEOF()来获取变量类型长度            |
| tTimeout | TIME                   | 读取超时时间，默认5s                                 |

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680224e4e0e83.png)



11.登入客户端192.168.110.195，下载运行程序。

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680224eef3ecb.png)

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680224f5f08a4.png)


将xRead变量置为True，ReadData成功获取值4294967295
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680224fd9339e.png)


11.使用输入助手添加Write功能块的实例，同时声明xWrite变量作为写入启动变量，WriteData作为写入数据，本例写入服务端变量Application.PLC\_PRG.udiVar11，写入值为1122334455.

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/6802250a58079.png)


12.登录客户端设备，将xWrite置TRUE。写入完成。
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680225164d622.png)


查看服务端PLC，udiVar11的值已经修改为1122334455
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/6802255cd436b.png)

13.可以验证是否写入成功，将xRead再次置TRUE，读取udiVar11，可以看到读取值与写入值相同，说明写入成功
![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/68022569cd3bb.png)

![](https://resource.helplook.net/docker_production/3648ne/article/usvv6HdR/680225744a95a.png)


### 三.实验注意点

**1、无法读取变量数值**

解决方法：检查客户端symbol中的变量路径是否与服务端的一致

**2、读取变量数值不正确**

解决方法：检查客户端读取变量的类型是否与服务端类型一致，使用ADR()和SIZEOF()命令获得指针和数据大小


## 功能介绍

**1、功能块FB\_AcpReadSymbol介绍**

![](images/image-77.png)

* 输入参数

| 参数名称     | 参数类型                   | 描述说明                                    |
| -------- | ---------------------- | --------------------------------------- |
| targetId |  ARRAY\[0..5] OF USINT | 连接服务端的IP地址，数组最后两位固定为1                   |
| bExecute | BOOL                   | 上升沿启动功能块，进行ACP变量读取                      |
| symbol   | String                 | 读取服务端的变量地址，如‘Application.PLC\_PRG.Var1’ |
| pDst     | Pointer to BYTE        | 读取服务端的变量数据，数值以BYTE的形式存储在指针指向的地址中        |
| cbDst    | UDINT                  | 读取服务端的变量数据长度，使用SIZEOF()来获取变量类型长度        |
| tTimeout | TIME                   | 读取超时时间，默认5s                             |

* 输出参数

| 参数名称    | 参数类型   | 描述说明                     |
| ------- | ------ | ------------------------ |
| bBusy   | Bool   | 功能块运行状态，True为运行，False为空闲 |
| bError  | Bool   | 是否报错，True为有错误，False为正常   |
| errInfo | String | 错误信息                     |





**2、功能块FB\_AcpWriteSymbol介绍**

![](images/image-76.png)

* 输入参数

| 参数名称     | 参数类型                   | 描述说明                                    |
| -------- | ---------------------- | --------------------------------------- |
| targetId |  ARRAY\[0..5] OF USINT | 连接服务端的IP地址，数组最后两位固定为1                   |
| bExecute | BOOL                   | 上升沿启动功能块，进行ACP变量写入                      |
| symbol   | String                 | 写入服务端的变量地址，如‘Application.PLC\_PRG.Var1’ |
| pSrc     | Pointer to BYTE        | 写入服务端的变量数据，使用ADR()获取写入变量的地址             |
| cbSrc    | UDINT                  | 写入服务端的变量数据长度，使用SIZEOF()来获取变量类型长度        |
| tTimeout | TIME                   | 读取超时时间，默认5s                             |

* 输出参数

| 参数名称    | 参数类型   | 描述说明                     |
| ------- | ------ | ------------------------ |
| bBusy   | Bool   | 功能块运行状态，True为运行，False为空闲 |
| bError  | Bool   | 是否报错，True为有错误，False为正常   |
| errInfo | String | 错误信息                     |





## 附录

### 一、工智机手动安装deb组件方法

建议使用Device Manager安装、卸载插件，如需手动安装deb组件，方法如下：

1.将个人电脑连接至交换机中，并使其IP地址与工智机在同一网段中。

![](images/image-80.png)



2.将所需要的组件下载至个人电脑，并放置在同一文件夹下。

![](images/image-71.png)



3.鼠标右键文件夹空白处，选择“在终端中打开”

![](images/image-74.png)



4.通过scp命令将acpplcaccess\_0.1.5-rc.3\_amd64.deb文件传输到客户端工智机中。

```sql
scp -P 2224 acpplcaccess_0.1.5-rc.3_amd64.deb sinsegye@192.168.110.175:~
```

![](images/image-75.png)

密码为1.

![](images/image-73.png)

通过ssh 远程连接到工智机命令行

```sql
ssh -p 2224 sinsegye@192.168.110.175
```

![](images/image-72.png)

通过dpkg命令，安装acpplcaccess\_0.1.5-rc.3\_amd64.deb文件

```shell
sudo dpkg -i acpplcaccess_0.1.5-rc.3_amd64.deb
```

如果发生错误，则可以使用强制安装命令

```shell
sudo dpkg -i --force-overwrite acpplcaccess_0.1.5-rc.3_amd64.deb
```

![](images/image-70.png)



使用nano命令打开SinsegyeRTE.cfg文件

```sql
sudo nano /usr/local/etc/SinsegyeRTE/SinsegyeRTE.cfg
```

![](images/image-69.png)



在 \[ComponentManager]下，添加Component.0=AcpPlcAccess（红色部分视具体情况而增加)。Ctrl+X退出—选择Y—回车确定。

![](images/image-67.png)



重启工智机

```sql
sudo reboot
```



同理，使用如下命令将libacp\_0.1.0-rc.5\_amd64.deb组件安装至客户端的工智机中，本例客户端工智机IP为192.168.110.123

```shell
scp -P 2224 libacp_0.1.0-rc.5_amd64.deb sinsegye@192.168.110.123:~
ssh -p 2224 sinsegye@192.168.110.123
sudo dpkg -i libacp_0.1.0-rc.5_amd64.deb
```

将acpreadwrite\_0.0.1-rc.1\_amd64.deb组件安装至客户端的工智机中，本例客户端工智机IP为192.168.110.123

```shell
scp -P 2224 acpreadwrite_0.0.1-rc.1_amd64.deb sinsegye@192.168.110.123:~
ssh -p 2224 sinsegye@192.168.110.123
sudo dpkg -i acpreadwrite_0.0.1-rc.1_amd64.deb
```

使用nano命令打开SinsegyeRTE.cfg文件

```sql
sudo nano /usr/local/etc/SinsegyeRTE/SinsegyeRTE.cfg
```

在 \[ComponentManager]下，添加Component.0=acpreadwrite（红色部分视具体情况而增加）

![](images/image-68.png)

重启工智机

```shell
sudo reboot
```



### 二、错误诊断

下表概述了可能出现的意外操作行为以及解决方法。

| **意外操作行为**             | **解决方法**                |
| ---------------------- | ----------------------- |
| 读写的变量名称与服务端的变量路径或名称不相同 | 修改变量路径或名称               |
| 读写的变量类型与服务端的变量类型不相同    | 修改变量类型                  |
| 读写的结构体或结构体子成员类型与服务端不相同 | 确认服务端结构体，修改读取的结构体类型及子成员 |



### 三、支持与服务

中科时代为公司产品及解决方案提供全方位支持与服务，确保针对相关问题给予快速且专业的响应。

**资料下载**

我们的资料下载专区涵盖了丰富的文件资源，包括应用案例、技术文档、产品介绍等，满足您的多样化需求。

资料下载地址：https://help.sinsegye.com.cn/

**获取支持**

如需中科时代产品的本地支持与服务，请随时联系我们。您可以通过访问我们的官方网站www.sinsegye.com.cn，查找中科时代的分公司地址，并获取更多关于中科时代的信息。

此外，您还可以通过以下方式联系我们：

* 热线电话：400-013-2158

* 邮箱地址：<Sales@sinsegye.com.cn>